from transformers import AutoModelForCausalLM, AutoTokenizer
from peft import PeftConfig, PeftModel

model_path = '/data/home/zhanghx/code/DataContaminate/ckpts/model/newllama-2-7b-hf/seed_1/answer_0.83_4'

config = PeftConfig.from_pretrained(model_path)
model = AutoModelForCausalLM.from_pretrained(config.base_model_name_or_path)
lora_model = PeftModel.from_pretrained(model, model_path)
tokenizer = AutoTokenizer.from_pretrained(config.base_model_name_or_path)

# 将 LoRA 权重合并到基础模型中
model.load_state_dict(lora_model.state_dict(), strict=False)

save_path = "/data/home/zhanghx/model/lora_model_answer"
# 保存模型和分词器
model.save_pretrained(save_path)
tokenizer.save_pretrained(save_path)

print(f"模型和分词器已保存到 {save_path}")